/*
   event.cc - This is Foundation (and so, another journey begins!)

   Marc Wolfgram, 25Jan91
   ----------------------------------------------------------------
 */

#pragma noroot
#pragma keep "o/event"

#include "Shell.h"
#include <foundation.h>
#include <qdaux.h>
#include <desk.h>
#include <list.H>
#include <lineedit.h>
#include <stdio.h>
#include <ctype.h>
#include <intmath.h>
#include <locator.h>
#include <print.h>
#include <scrap.h>

void            activateEvent(void);
void            checkClipboard(void);
void 			closeREM(word, word);
word            closeRoot(word, word);
void            ctrlEvent(void);
void            generalEvent(word);
void            goAwayEvent(void);
void            main(void);
void            menuEvent(long, word);
word 			Printer(word);
void            swapVidMode(void);
void            showClipboard(void);

/* DEBUG WINDOW */
void UpdateBWin(word);
void bWindow(void);
GrafPortPtr bWinPtr;
extern long callVector;

extern word         workIndex;
extern workFileRec  workList[];  /* work file array [0..3] */
extern word 		fMenuGlobal;
extern char         tempName[], nameText[];  /* from names.c */
extern void         AttrProc(), DrawProc(), NullProc();
extern MenuTemplate **selectorMenuH;
extern long 		**selectorItemH;
extern master       MasterRace[];

word fResID, pResID, qFlag, vMode, c320, wClass, fScrapCnt, CurMurphy, nameState, moonIndex;
long masterTaskMask, orTaskMask, andTaskMask, workTaskMask, strings[36], moonTick, moonPhase[8];
char *AlertArray[10];
GrafPortPtr     SysWPtr, nameTargetWinP;
MenuBarRecHndl  SysMHndl;
remFileLinkPtr  linkREM;
remTypeLinkPtr  rootREM, CurREM;
fWindowRec      CurWindow;
WindColorPtr    SysWColor, WColors[8];
EventRecord     fTaskRec, miscTaskRec;
prefDataHndl    prefDataH;

VersionRecGS    versionPB = { 1, 0 };
QuitRecGS       quitPB = { 0, 0L, 0 };

fActivateRec    fActivatePB;    /* call parameter blocks */
fCloseRec       fClosePB;
fEventRec       fEventPB;
fOpenRec        fOpenPB;
fCloseRec       fPrintPB;
fCloseRec       fWritePB;
fVidModeRec     fVidModePB;

fResLinkRec     fBuildLinkPB;   /* callback parameter blocks */
fResRefRec		fDeletePB;
fResNameRec     fGetWTitlePB, namePB;
fResDataRec     attrPB;
fResData2Rec    chngPB;

/*--------------------------------------
    main is the Foundation event loop

    Marc Wolfgram,  8/ 9/91 17:50:10
*/
void main(void)
{
word            i, err, temp, task;
long			hdiResult;
GrafPortPtr     winP;
Handle          tHand;

    GetVersion(&versionPB);
    if ((versionPB.version &0x07ff) < 0x0400) {
		InitCursor();
        temp = AlertWindow(0x0034, 0L, Version_Alert);
        return;
    }

    if (versionPB.version & 0x8000) {
		InitCursor();
        temp = AlertWindow(0x0034, 0L, 0x15L);
		WaitCursor();
	}

    vMode = 1;
    c320 = 0;

    masterTaskMask  = 0x001f7fffL;  /* 0001 1111 0111 1111 1111 1111 */
    orTaskMask      = 0x00002186L;  /* 0000 0000 0010 0001 1000 0110 */
    andTaskMask     = 0x001fffffL;  /* 0001 1111 1111 1111 1111 1111 */
    workTaskMask = masterTaskMask;

    SysWPtr = GetWMgrPort();
    SetPort(SysWPtr);

    fResID = GetCurResourceFile();

	bWinPtr = 0L;	/* DEBUG WINDOW */

	moonIndex = 0;
	moonTick = 0L;
	for (i = 0; i < 8; i++)
    	(Pointer) moonPhase[i] = deref(LoadResource(rCursor, (long) i + 1L));

    winP = openAboutWin(0);

    SysMHndl = NewMenuBar2(2, fMenuBar, 0L);
    SetSysBar(SysMHndl);
    SetMenuBar(0L);
    FixAppleMenu((word) AppleMenu);
    FixMenuBar();
    SetMenuFlag(0x0080, 4);
    DrawMenuBar();

	(long) selectorMenuH = 0L;
	(long) selectorItemH = 0L;

    remInit();  /* sane magic at last */
    stringInit(); /* localization stringlist data */

    fScrapCnt = GetScrapCount();

    for (i = 0; i < 8; i++)
        (Pointer) WColors[i] = deref(LoadResource(rWindColor, (long) i + 1L));
    (Pointer) SysWColor = deref(LoadResource(rWindColor, 0x7ff0001L));

    for (i = 0; i < 4; i++)
        CheckMItem(0, (word) EditFile1Item + i);

    CloseWindow(winP);

    prefDataH = getPrefs();

    InitCursor();

    qFlag = FALSE;

    wClass = 0;     /* startup default is no window open */

    fMenuGlobal = 0x8140; /* New Open About Other Help Preferences */

    do {
        fTaskRec.wmTaskMask = workTaskMask;
        fTaskRec.wmTaskMask |= orTaskMask;
        fTaskRec.wmTaskMask &= andTaskMask;

        task = TaskMaster(everyEvent , &fTaskRec ) ;

        UpdateBWin(task);  /* DEBUG WINDOW */

        switch (task) {

        case inNull:
            if (fTaskRec.what) /* disable the twilight zone */
				continue;

            hdiResult = HandleDiskInsert(0xc000, 0);

			winP = FrontWindow();
            if (winP) {
				if (GetSysWFlag(winP))     	/* if its a da then... */
					SetupMenu(0x8c27 | fMenuGlobal);
				else                   		/* otherwise... */
                    SetupMenu(0x4020); /* Close */
            }
            else
				SetupMenu(0x0020); /* Close */

        case mouseDownEvt:
        case mouseUpEvt:
        case keyDownEvt:
        case autoKeyEvt:
        case updateEvt:
        case wInDesk:
        case wClickCalled:
        case wInContent:
        case wInDrag:
        case wInGrow:
        case wInZoom:
        case wInInfo:
        case wInFrame:
        case wTrackZoom:
        case wHitFrame:
            generalEvent(task);
            break;

        case activateEvt:
            wClass = winSetup((GrafPortPtr) fTaskRec.wmTaskData);
            activateEvent();
            break;

        case wInMenuBar:
        case wInSpecial:
            menuEvent(fTaskRec.wmTaskData, task);
            break;

        case wInGoAway:
            goAwayEvent();
            break;

        case wInControl:
            ctrlEvent();
            break;
        }

        checkListStatus();
        checkClipboard();

    } while (!qFlag);  /* Keep going until qFlag is set */

    disposeAddMenu();
    disposeTypeLink(rootREM);
    disposeFileLink(linkREM);
    winP = findSignature(0x48e5, 0, 0, 0L);
    if (winP) {
        DisposeHandle(GetWRefCon(winP));
        CloseWindow(winP);
    }
    if (GetScrapState()) {
         winP = NoteWindow("Saving Clipboard...");
         UnloadScrap();
         CloseWindow(winP);
    }

} /* main */

/*======================================
 *  the event handlers
 *--------------------------------------
    generalEvent handles all non-specific event routing

    locals consume no stack space

    Marc Wolfgram
*/
void generalEvent(word task)
{

    switch (wClass) {
    case 0:     /* no window open */
    case -1:    /* not Foundation */
        break;

    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fEventPB.resType = CurWindow.resType;
        fEventPB.resID = CurWindow.resID;
        fEventPB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            fEventPB.fFlag |= 0x0400;   /* set selector bit */
            fEventPB.fFlag &= 0xff7f;   /* clear menu bit */
        }
        else
            fEventPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        fEventPB.taskCode = task;
        callREM(_EVENT, (Pointer) &fEventPB);
        break;
    }
}

/*--------------------------------------
    activateEvent handles the necessary magic specific to you guessed it...

    locals consume 4 bytes of stack space

    Marc Wolfgram
*/
void activateEvent(void)
{
word i, setCloseFile;
fWindowRecHndl  refH;

    workTaskMask = masterTaskMask;

    setCloseFile = 0;

    switch (wClass) {
    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fActivatePB.resType = CurWindow.resType;
        fActivatePB.resID = CurWindow.resID;
        fActivatePB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            (long) nameTargetWinP = 0L;
            fActivatePB.fFlag |= 0x0400;    /* set selector and activate bits */
            fActivatePB.fFlag &= 0xff7f;    /* clear menu bit */
        }
        else
            fActivatePB.fFlag &= 0xfb7f;    /* clear selector and menu bits */

        if (fTaskRec.modifiers & 0x0001) { /* activate */
            setCloseFile++;
            if (wClass == REM_nselector) {  /* getlink - exclude HexREM too */
                fBuildLinkPB.pCount = 8;
                fBuildLinkPB.hostType = CurWindow.resType;
                fBuildLinkPB.hostID = CurWindow.resID;
                fBuildLinkPB.resFileID = CurWindow.resFileID;
                remBuildLinkHand((fResLinkRecPtr) &fBuildLinkPB);
                fActivatePB.linkHand = fBuildLinkPB.linkHand;
            }
            else
                fActivatePB.linkHand = 0L;

            fActivatePB.fFlag |= 0x8000;    /* set activate bit */
            if (wClass != REM_nselector) {
            	insertMenu5(CurREM->menuHndl);
                nameTargetWinP = (GrafPortPtr) fTaskRec.wmTaskData;
            }
            callREM(_ACTIVATE, (Pointer) &fActivatePB);
            workTaskMask = CurWindow.remTaskMask;
        }
        else {                              /* deactivate */
            fActivatePB.fFlag &= 0x7fff;    /* clear activate bit */
            fActivatePB.linkHand = 0L;
            callREM(_ACTIVATE, (Pointer) &fActivatePB);
            removeMenu5();
        	SetupMenu(0x041f);
        }
        break;

    case REM_fileroot:
        (long) nameTargetWinP = 0L;
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            setCloseFile++;
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
            SetupMenu(0x4800);
            SetupMenu(0x041f);
        }
        else
        	SetupMenu(0x0800);
        break;

    case REM_tselector:
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
        	nameTargetWinP = (GrafPortPtr) fTaskRec.wmTaskData;
            setCloseFile++;
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
            SetupMenu(0x4c00);
            SetupMenu(0x001f);
        }
        else
        	SetupMenu(0x0c00);
        break;

    case 0xe8:  /* namer */
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            nameState = 0x00ff;
            drawNamer(nameTargetWinP);
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
        }
        else
            (long) nameTargetWinP = 0L;
        break;

    default: /* and other windows */
        (long) nameTargetWinP = 0L;
        if (fTaskRec.modifiers & 0x0001) {    /* activate */
            removeMenu5();
            workTaskMask = CurWindow.remTaskMask;
        }
        break;
    }
    if (setCloseFile) {
        SetMItemName(&workList[workIndex].fileName[0], (word) CloseFileItem);
        SetMItemName(&workList[workIndex].packName[0], (word) OptimizeItem);
        SetupMenu(0x4200);
        CalcMenuSize(0,0,2);
        CheckMItem(-1, (word) EditFile1Item + workIndex);
        for (i = 0; i < 4; i++)
            if (i != workIndex)
                CheckMItem(0, (word) EditFile1Item + i);
    }
    drawNamer(nameTargetWinP);
}

/*--------------------------------------
    menuEvent handles routing to menu item hits...

    locals consume 12 bytes of stack space

    Marc Wolfgram,  8/ 9/91 20:53:14
*/
void menuEvent(long menuID, word task)
{
word i, temp, skip, hitItem, hitMenu;
remTypeLinkPtr  typeLink;
GrafPortPtr winP;

    asm {
        lda menuID
        sta hitItem
        lda menuID+2
        sta hitMenu
    }

    switch (hitItem) {

    case CopyItem:
        if (wClass == REM_tselector) {
        	itemCopy();
			break;
     	}

    case PasteItem:
        if (wClass == REM_tselector || wClass == REM_fileroot) {
        	itemPaste();
			break;
     	}

    case UndoItem:
    case CutItem:
    case ClearItem:
        generalEvent(task);
        break;

    case CloseItem:
        goAwayEvent();
        break;

    case SelectAllItem:
        generalEvent(task);
        break;

    case QuitItem:
        temp = skip = 0;

        for (i = 0; i < 4; i++) {   /* handle the dirty work first */
            if (workList[i].wFlag & 0x4000) {
                temp = closeRoot(i, 1);
                if (temp)
                    skip++;
            }
        }
        if (skip)
            break;

        for (i = 0; i < 4; i++)     /* then kill any stragglers... */
            if (workList[i].wFlag & 0x1000)
                closeRoot(i, 1);

        qFlag = TRUE;
        break;

    case NewItem:
        NewFile();
        break;

    case OpenItem:
        OpenFile((prefDataHndl) 0L);
        break;

    case SaveItem:
        SaveFile(workIndex, workList[workIndex].wFlag & 0x2000);
        break;

    case SaveAsItem:
        SaveFile(workIndex, -1);
        break;

    case PageSetupItem:
    	Printer(1);
        break;

    case PrintItem:
        Printer(0);
        break;

    case AboutItem:
        switch (wClass) {
        case -1:    /* not Foundation */
            temp = 0;
            break;

        case REM_nselector: /* one of the REMs */
        case REM_native:
        case REM_script:
        case REM_hexascii:
            temp = CurREM->link->resFileID;
            break;

        default: /* the shell */
            temp = fResID;
            break;
        }
        if (temp)
            CloseWindow(openAboutWin(temp));
        break;

    case ShowClipboardItem:
        showClipboard();
        break;

    case SwitchModeItem:
        swapVidMode();
        break;

    case PreferencesItem:
        prefDataH = editPrefs(prefDataH);
        break;

    case ImportDataItem:
        temp = AlertWindow(0x0034, 0L, Construction_Alert);
        break;

    case UserResourceItem:
        fOpenPB.resType = 0;
        fOpenPB.resID = 0L;
        fOpenPB.fFlag = 0x1800; /* hexedit & script bits set */
        fOpenPB.Data = 0L;
        fOpenPB.wColorPtr = (Pointer) WColors[workIndex];
        callREM(_OPEN, (Pointer) &fOpenPB);
        break;

    case HelpItem:
		bWindow();
/*      temp = AlertWindow(0x0034, 0L, Construction_Alert); */
        break;

    case CloseFileItem:
        closeRoot(workIndex, 0);
        break;

    case EditFile1Item:
    case EditFile2Item:
    case EditFile3Item:
    case EditFile4Item:
        SelectWindow(workList[hitItem-EditFile1Item].rootWinP);
        break;

    case OptimizeItem:
        temp = AlertWindow(0x0034, 0L, Construction_Alert);
        break;

    case NameResItem:
        openNamer();
        break;

    default:
        if (hitItem > 0x2ef) {  /* rem menu hit - including selector stuff */
            generalEvent(task);
            break;
        }
        if (hitItem > 0x1ff) {  /* add type hit */
            typeLink = getMenuLinkRef(hitItem);
            fOpenPB.resType = typeLink->resType;
            fOpenPB.resID = 0L;
            fOpenPB.fFlag = typeLink->rFlag & 0x1000;
            fOpenPB.Data = 0L;
            fOpenPB.wColorPtr = (Pointer) WColors[workIndex + c320];
            callREM(_OPEN, (Pointer) &fOpenPB);
            break;
        }
        temp = AlertWindow(0x0034, 0L, Construction_Alert);
        break;
    }
    HiliteMenu(0, hitMenu) ; /* Un-hilite menu title */

} /* doMenuHit */

char titleBuf[128];

/*--------------------------------------
    ctrlEvent handles hits in controls

    locals consume 40 bytes of stack space

    Marc Wolfgram,  8/ 9/91 22:26:12
*/
void ctrlEvent(void)
{
word            i, j, listItem, type;
long            ID;
fWindowRecHndl  refH, nameTargetRefH;
GrafPortPtr     winP, found;
nameSubPtr      nameP;
fListCtlRecHndl ctlH;
fMemberHndl     memH;
fMemberPtr      memP;

    ctlH = (fListCtlRecHndl) fTaskRec.wmTaskData2;  /* we know the ancestry */
    winP = (GrafPortPtr) (**ctlH).ctlOwner;
    refH = (fWindowRecHndl) GetWRefCon(winP);

    switch (wClass) {
    case REM_nselector:
    case REM_native:
    case REM_script:
    case REM_hexascii:
        fEventPB.resType = CurWindow.resType;
        fEventPB.resID = CurWindow.resID;
        fEventPB.fFlag = CurMurphy;

        if (wClass == REM_nselector) {
            fEventPB.fFlag |= 0x0400;   /* set selector bit */
            fEventPB.fFlag &= 0xff7f;   /* clear menu bit */
        }
        else
            fEventPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        fEventPB.taskCode = wInControl;
        callREM(_EVENT, (Pointer) &fEventPB);
        break;

    case REM_fileroot:
    case REM_tselector:
        ctlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
        listItem = NextMember2(0, ctlH);
        memH = (**ctlH).ctlListRef;
        (Pointer) memP = deref((Handle) memH);

        if (fTaskRec.wmTaskData4 == 1L) { /* popup - set action, then go on */
            (**refH).remSignature = GetCtlValue(fTaskRec.wmTaskData2);
			if ((**prefDataH).pFlag & 0x4000)
				return;
		}
        else if (fTaskRec.wmTaskData4 == 2L) {  /* list - do we dispatch? */
            if (fTaskRec.wmClickCount != 2) {   /* no, not a double click */
    			if (wClass == REM_tselector)	/* update the namer maybe */
		    		drawNamer(nameTargetWinP);
                break;
         	}
        }
        else            /* all other shit - list scroll parts for example */
            break;

        if (!listItem)          /* is something selected - maybe not, eh? */
            break;

        i = (**refH).remSignature;  /* switch with the appropriate action */
        switch (i) {
        case 1:                     /* root - open a type/custom selector */
            type = (word) memP[listItem-1].nref;
            (long) found = (long) findSignature(REM_signature + REM_nselector + workIndex, 1, type, 0L) +
                    (long) findSignature(REM_signature + REM_tselector + workIndex, 1, type, 0L);
            if (!found)
                openTypeWindow(workIndex, type);
            break;

        case 2:                     /* root - display the type info alert */
            type = (word) memP[listItem-1].nref;
            showTypeInfo(workIndex, type);
            break;

        case 0x2f0:       			/* std selector - open the editor or  */
        case 0x2f1:         		/*                         script or  */
        case 0x2f2:                 /*                         HexEdit    */
            openEditor((**refH).resType, memP[listItem-1].nref, i & 3);
            break;

        case 0x2f3:                 /* std selector - edit the attributes */
            editAttributes((**refH).resType, memP[listItem-1].nref);
            break;

        case 0x2f4:                 /* std selector - death to this item! */
            deleteRequested((**refH).resType, memP[listItem-1].nref);
            break;

        case 0x2f5:                 /* std selector - export to some file */
            exportRequested((**refH).resType, memP[listItem-1].nref);
            break;

    	case 0x2f6:					/* show parents - future */
            findHostRequested((**refH).resType, memP[listItem-1].nref);
            break;

	    case 0x2f7:					/* show children - future */
            findChildRequested((**refH).resType, memP[listItem-1].nref);
            break;

        default:                    /* something else - we are mystified! */
            break;
        }
        break;

    case 0x00e4:        /* help */
    case 0x00e5:        /* clipboard */
        break;

    case 0x00e8:        /* namer */
        if (fTaskRec.wmTaskData4 == 1L) { /* namer apply */
            GetLETextByID(winP, 2L, nameText);
            nameTargetRefH = (fWindowRecHndl) GetWRefCon(nameTargetWinP);
            namePB.pCount = 3;
            namePB.resType = (**nameTargetRefH).resType;
            namePB.resID = (**nameTargetRefH).resID;
            if (!namePB.resID) {
        		ctlH = (fListCtlRecHndl) GetCtlHandleFromID(nameTargetWinP, 2L);
        		listItem = NextMember2(0, ctlH);
                if (listItem) {
                	memH = (**ctlH).ctlListRef;
        			(Pointer) memP = deref((Handle) memH);
            		namePB.resID = memP[listItem-1].nref;
        		}
            }
            namePB.resName = nameText;
            remSetResourceName(&namePB);
            nameState = 0x00ff;
        }
        else if (nameState == 0x00ff && fTaskRec.wmTaskData4 == 2L)
            nameState = 0x0000; /* LE hit, so apply is now valid */

        HiliteControl(nameState, GetCtlHandleFromID(winP, 1L));
        break;

    case 0x00ec:        /* srcEdit */
        break;

    default: /* no window or not Foundation's */
        break;
    }
}

/*--------------------------------------
    goAwayEvent does away with what's ours

    locals consume 8 bytes of stack space

    Marc Wolfgram,  8/ 9/91 22:27:48
*/
void goAwayEvent(void)
{
fListCtlRecHndl listCtlH;
GrafPortPtr     winP;

    winP = FrontWindow();

  	switch (wClass) {
    case 0:     /* no window open */
        break;

    case REM_nselector:
    	if (fTaskRec.modifiers & optionKey)
	    	closeREM(workIndex, CurWindow.resType);
		else {
        	fClosePB.resType = CurWindow.resType;
        	fClosePB.resID = CurWindow.resID;
        	fClosePB.windowPtr = (Pointer) winP;
        	fClosePB.fFlag |= 0x0400;   /* set selector bit */
        	fClosePB.fFlag &= 0xff7f;   /* clear menu bit */
        	callREM(_CLOSE, (Pointer) &fClosePB);
        }
        break;

    case REM_native:
    case REM_script:
    case REM_hexascii:
        fClosePB.resType = CurWindow.resType;
        fClosePB.resID = CurWindow.resID;
        fClosePB.windowPtr = (Pointer) winP;
       	fClosePB.fFlag = CurMurphy;
        fClosePB.fFlag &= 0xfb7f;   /* clear selector and menu bits */
        if (winP == nameTargetWinP)
            (long) nameTargetWinP = 0L;
        callREM(_CLOSE, (Pointer) &fClosePB);
        break;

    case REM_fileroot:
    	if (fTaskRec.modifiers & optionKey)
	    	closeTypes(workIndex);
		else
		  	closeRoot(workIndex, 0);
        break;

    case REM_tselector:
    	if (fTaskRec.modifiers & optionKey) {
	    	closeREM(workIndex, CurWindow.resType);
			break;
		}
		listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
        if ((**listCtlH).ctlListRef)
            DisposeHandle((**listCtlH).ctlListRef);
    case 0xe5: /* clipboard */
	case 0xe8: /* namer */
        DisposeHandle(GetWRefCon(winP));
        CloseWindow(winP);
        break;

    default:
        if (!GetSysWFlag(winP))
            CloseWindow(winP);
        break;
    }
}

/*======================================
 *  menu handlers and misc functions
 *--------------------------------------
    winSetup is passed a window grafportptr and returns one of the
    following values based on the window's secrets...

           0x0000       No window open
        0x0010..0090    REM or non-general shell window
        0x00e0..00ef    General shell window
           0xffff       Not a Foundation window (NDA)

    the CurWindow structure is filled appropriately if the window is one
    of ours.

    the workIndex variable is set if the window is associated with an open
    Foundation work file.

    Marc Wolfgram,  8/ 9/91 17:34:49
*/
word winSetup(GrafPortPtr winPtr)
{
word retVal, i;
Handle refConH;
fWindowRecPtr   refConP;


    if (winPtr != 0L) {
    	refConH = (Handle) GetWRefCon(winPtr);
        (Pointer) refConP = deref(refConH);
        CurWindow.Signature = retVal = refConP->Signature;
        if ((retVal & 0xff00) == REM_signature) {
			SetupMenu(fMenuGlobal);
            CurWindow.resID = refConP->resID;
            CurWindow.resType = refConP->resType;
            CurWindow.resFileID = refConP->resFileID;
            CurWindow.remTaskMask = refConP->remTaskMask;
            CurWindow.remSignature = refConP->remSignature;
            CurWindow.resPrivate = refConP->resPrivate;
            if ((retVal & 0x00f0) == REM_general)
				retVal &= 0x00ff;
            else {
                workIndex = retVal & 0x0003;

                retVal &= 0x00f0;
                switch (retVal) {
                case REM_nselector:
                case REM_native:
                    CurREM = getTypeLinkRef(refConP->resType);
                    CurMurphy = 0x0000;
                    break;

                case REM_script:
                case REM_hexascii:
                    CurREM = getTypeLinkRef(0);
                    CurMurphy = (retVal == REM_script) ? 0x1000 : 0x0800;
                    break;

                default:
                    CurREM = 0L;
                    CurMurphy = 0x0000;
                	break;
                }
        	}
		}
        else
            retVal = -1;
    }
    return retVal;
}

/*--------------------------------------
    swapVidMode

    Marc Wolfgram,  8/ 9/91 20:42:07
*/
void swapVidMode(void)
{
word i, wfd, wType, qdSCB, listCnt;
Point pt;
long  qdWAP;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;
fMemberHndl     memberH;
fListCtlRecHndl listCtlH;
remTypeLinkPtr  remP;

    qdSCB = GetMasterSCB();
    qdSCB ^= 0x80;
    vMode = (qdSCB & 0x80) ? 1 : 0;
    c320 = vMode ? 0 : 4;

    qdWAP = (long) GetWAP(0, 4);

    QDAuxShutDown();
    QDShutDown();

    QDStartUp((word) qdWAP, qdSCB, 0, fMemID);
    GrafOff();
    printf((char *) strings[28]);

    QDAuxStartUp();

    ClampMouse(0, (vMode) ? 639 : 319, 0, 199);
    HomeMouse();
    ShowCursor();

    WindNewRes();
    MenuNewRes();
    CtlNewRes();

	SetupMenu(vMode ? 0x4100 : 0x0100);
    CloseAllNDAs();

    winP = GetFirstWindow();
    while(winP) {
        refH = (fWindowRecHndl) GetWRefCon(winP);
        (Pointer) refP = deref((Handle) refH);

        wType = refP->Signature & 0x00ff;
        if (wType < 0x00e0) {
            wfd = wType & 0x0003;
            wType &= 0x00f0;
        }

        switch (wType) {
        case REM_nselector:
        case REM_native:
            remP = getTypeLinkRef(refP->resType);
            if (remP->rFlag & 0x0010) { /* 320 aware */
                printf((char *) strings[0], refP->resType, refP->resID, wfd+1);
                fVidModePB.resType = refP->resType;
                fVidModePB.resID = refP->resID;
                fVidModePB.fFlag = (vMode) ? 0x4000 : 0x0000;
                if (wType == REM_nselector)
                	fVidModePB.fFlag |= 0x0400;
                fVidModePB.wColorPtr = (Pointer) WColors[wfd + c320];
                fVidModePB.windowPtr = (Pointer) winP;
                callREM(_VIDMODE, (Pointer) &fVidModePB);
                break;
            }

        case REM_script:
        case REM_hexascii:
            printf((char *) strings[vMode ? 8 : 5], refP->resType, refP->resID, wfd+1);
            ShowHide(vMode, winP);
            break;

        case REM_fileroot:
            printf((char *) strings[1], wfd+1);
            (CtlRecHndl) listCtlH = GetCtlHandleFromID(winP, 2L);
            listCnt = (**listCtlH).ctlListSize;
            memberH = (fMemberHndl) (**listCtlH).ctlListRef;
            (**listCtlH).ctlListRef = 0L;
            HideControl(listCtlH);
            DisposeControl(listCtlH);
            (CtlRecHndl) listCtlH = NewControl2(winP, 2, (wType == REM_fileroot) ? 0x2002L : 0x2004L);
            (**listCtlH).ctlListSize = listCnt;
            (**listCtlH).ctlMemSize = 9;
            (**listCtlH).ctlListRef = memberH;
            (**listCtlH).ctlMoreFlags = 0x1401;
            NewList2(0L, 1, memberH, 1, listCnt, listCtlH);
            DrawOneCtl(listCtlH);
            SetFrameColor(WColors[wfd + c320], winP);
            ShowWindow(winP);
            break;

        case REM_tselector:
            printf((char *) strings[3], refP->resType, wfd+1);

            refP->remSignature = SetupTypeMenu(refP->resType, winP);

            (CtlRecHndl) listCtlH = GetCtlHandleFromID(winP, 2L);
            listCnt = (**listCtlH).ctlListSize;
            memberH = (fMemberHndl) (**listCtlH).ctlListRef;
            (**listCtlH).ctlListRef = 0L;
            HideControl(listCtlH);
            DisposeControl(listCtlH);

            (CtlRecHndl) listCtlH = NewControl2(winP, 2, (wType == REM_fileroot) ? 0x2002L : 0x2004L);
            (**listCtlH).ctlListSize = listCnt;
            (**listCtlH).ctlMemSize = 9;
            (**listCtlH).ctlListRef = memberH;
            (**listCtlH).ctlMoreFlags = 0x1401;
            NewList2(0L, 1, memberH, 1, listCnt, listCtlH);

            DrawOneCtl(listCtlH);

            SetFrameColor(WColors[wfd + c320], winP);

            ShowWindow(winP);
            break;

        case 0x00e4:                /* help - 320 is beyond this */
            printf((char *) strings[vMode ? 9 : 6]);
            ShowHide(vMode, winP);
            break;

        case 0xe5: /* close the scrap window */
            printf((char *) strings[4]);
            DisposeHandle(refH);
            CloseWindow(winP);
            winP = GetNextWindow(winP);
            continue;

        case 0xe8:
            printf((char *) strings[2]);
            break;

        case 0x00ec:                /* srcEdit */
            printf((char *) strings[vMode ? 10 : 7]);
            ShowHide(vMode, winP);
            break;

        default:
            break;
        }
        pt.v = (winP->portInfo.boundsRect.v1 ^ 0xffff) + 1;
        pt.h = (winP->portInfo.boundsRect.h1 ^ 0xffff) + 1;
        if (vMode)
            pt.h *= 2;
        else
            pt.h /= 2;
        MoveWindow(pt, winP);

        HUnlock(refH);
        winP = GetNextWindow(winP);
    }

    RefreshDesktop(0L);

    printf("\x05");
/*          |
            Turn on cursor
 */

	winP = FrontWindow();
	if (winP)
		SelectWindow(winP);

    GrafOn();
}

/*--------------------------------------
    findSignature locates an open foundation window based on its refcon

    Marc Wolfgram,  9/ 7/91  0:05:03
*/
GrafPortPtr findSignature(word signature, word mode, word type, long ID)
{
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP, found;

    (long) found = 0L;
    winP = GetFirstWindow();
    while(winP) {
        if (!GetSysWFlag(winP)) {
            refH = (fWindowRecHndl) GetWRefCon(winP);
            (Pointer) refP = deref((Handle) refH);
            if (refP->Signature == signature &&
               		((refP->resType == type && (refP->resID == ID || ID == 0L)) ||
               		(type == 0 && ID == 0))) {
                HUnlock(refH);
                found = winP;
                if (mode == 1)
                    SelectWindow(winP);
                if (mode == 2)
                    ShowHide(-1, winP);
                if (mode == 3)
                    ShowHide(0, winP);
                break;
            }
            HUnlock(refH);
        }
        winP = GetNextWindow(winP);
    }
    return found;
}

char *CloseQuitText[] = { "closing", "quiting" };

/*--------------------------------------
    closeRoot - returns -1 if canceled

    Marc Wolfgram,  9/18/91 20:26:14
*/
word closeRoot(word wfd, word action)
{
word 			i, j, retVal;
fCloseRec       closePB;
fListCtlRecHndl listCtlH;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    retVal = 0;
    flushWorkFile(wfd);

    if (workList[wfd].wFlag & 0x4000) {
        AlertArray[0] = &workList[wfd].rootName[1];
        AlertArray[1] = CloseQuitText[action];
        i = AlertWindow(0x0034, AlertArray, 7L);
        if (!i)
            return -1;
    }
    if (i == 2) {
        flushWorkFile(wfd);
        retVal = SaveFile(wfd, (workList[wfd].wFlag & 0x2000));
    }
    if (!retVal) {

        closeTypes(wfd);			/* close all the types and editors */

        workList[wfd].wFlag = 0;
        disposeWorkData(wfd);
        CloseWindow(workList[wfd].rootWinP);

        SetupMenu(0x4040);
        sprintf(workList[wfd].editName, (char *) strings[27], (char) wfd + '1');
        SetMItemName(&workList[wfd].editName[0], (word) EditFile1Item + wfd);
        DisableMItem((word) EditFile1Item + wfd);
        CheckMItem(0, (word) EditFile1Item + wfd);
        CalcMenuSize(0,0,3);

        if (countFiles() == 0) {
            SetMItemName2(2, (long) CloseFileItem, (word) CloseFileItem);
            SetMItemName2(2, (long) OptimizeItem, (word) OptimizeItem);
            SetupMenu(0x0280);
            CalcMenuSize(0,0,2);
            SetMenuFlag(0x0080, 4);
            DrawMenuBar();
            workTaskMask = masterTaskMask;
            for (i = (action) ? 0x48e4 : 0x48e8; i < 0x48f0; i++) { /* kill all the shell leftovers */
                winP = findSignature(i, 0, 0, 0L);
                if (winP) {
                    DisposeHandle(GetWRefCon(winP));
                    CloseWindow(winP);
                }
            }
            bWinPtr = 0L;
        }
        else if (workIndex == wfd) {
        	for (i = 0; i < 4; i++) {
                if (workList[i].wFlag & 0x1000) {
        			SetMItemName(&workList[i].fileName[0], (word) CloseFileItem);
        			SetMItemName(&workList[i].packName[0], (word) OptimizeItem);
        			SetupMenu(0x4200);
			        CalcMenuSize(0,0,2);
        			CheckMItem(-1, (word) EditFile1Item + i);
        			for (j = 0; j < 4; j++)
            			if (j != i)
                			CheckMItem(0, (word) EditFile1Item + i);
            		workTaskMask = masterTaskMask;
					workIndex = i;
		            break;
		     	}
			}
		}
    }
    return retVal;
}

/*--------------------------------------
	closeTypes (extracted from closeRoot)

	Marc Wolfgram,  1/ 5/92 11:16:06
*/
void closeTypes(word wfd)
{
fCloseRec       closePB;
fListCtlRecHndl listCtlH;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

	closeREM(wfd, 0);				/* close all the editors */

    winP = GetFirstWindow();        /* close all the types */
    while(winP) {
    	if (!GetSysWFlag(winP)) {
    		refH = (fWindowRecHndl) GetWRefCon(winP);
        	(Pointer) refP = deref((Handle) refH);
        	if ((refP->Signature & 0xfff0) == (REM_signature + REM_tselector) && (refP->Signature & 0x0003) == wfd) {
        		listCtlH = (fListCtlRecHndl) GetCtlHandleFromID(winP, 2L);
        		if ((**listCtlH).ctlListRef) {
        			DisposeHandle((**listCtlH).ctlListRef);
        			(**listCtlH).ctlListRef = 0L;
    			}
    	    	DisposeHandle(refH);
        		CloseWindow(winP);
    		}
      	}
        winP = GetNextWindow(winP);
    }
}

/*--------------------------------------
	closeREM (extracted from closeRoot)

	Marc Wolfgram,  1/ 5/92 11:16:06
*/
void closeREM(word wfd, word resType)
{
fCloseRec       closePB;
fWindowRecHndl  refH;
fWindowRecPtr   refP;
GrafPortPtr     winP;

    winP = GetFirstWindow();        /* close all the REM's */
    while(winP) {
    	if (!GetSysWFlag(winP)) {
            refH = (fWindowRecHndl) GetWRefCon(winP);
            (Pointer) refP = deref((Handle) refH);
            if (refP->Signature < (REM_signature + REM_fileroot) && (refP->Signature & 0x0003) == wfd &&
               		(!resType || (resType == refP->resType))) {
                closePB.resType = refP->resType;
                closePB.resID = refP->resID;
                closePB.windowPtr = (Pointer) winP;
                switch (refP->Signature & 0x0070) {
                case 0x0010:
                	closePB.fFlag = 0x0400;
                    break;
                case 0x0040:
                    closePB.fFlag = 0x1000;
                    break;
                case 0x0060:
                    closePB.fFlag = 0x0800;
                    break;
                default:
                    closePB.fFlag = 0;
                    break;
                }
                callREM(_CLOSE, (Pointer) &closePB);
                DisposeHandle(refP->resPrivate);
            	DisposeHandle(refH);
            }
        }
        winP = GetNextWindow(winP);
    }
}

word fEventMagic[] =   { 0x0000, 0x1000, 0x0800, 0x4820, 0x4840, 0x4860, 0x4820, 0x4840  };

/*--------------------------------------
    openEditor - split out of control handler for fSelector

    Marc Wolfgram, 10/22/91 19:09:16
*/
word openEditor(word resType, long resID, word mode)
{
word            i, retVal;
GrafPortPtr     found;

    found = findSignature(fEventMagic[mode+3] + workIndex, 1, resType, resID);
    if (found)
        SelectWindow(found);
    else {
        (long) found = (long) findSignature(fEventMagic[mode+4] + workIndex, 0, resType, resID)
                     + (long) findSignature(fEventMagic[mode+5] + workIndex, 0, resType, resID);
        if (!found) {
            fOpenPB.resType = resType;
            fOpenPB.resID = resID;
            fOpenPB.fFlag = fEventMagic[mode];
            fOpenPB.Data = 0L;
            fOpenPB.wColorPtr = (Pointer) WColors[workIndex + c320];
            retVal = callREM(_OPEN, (Pointer) &fOpenPB);
        }
        else  {
            fGetWTitlePB.pCount = 3;
            fGetWTitlePB.resType = resType;
            fGetWTitlePB.resID = resID;
            fGetWTitlePB.resName = titleBuf;
            remGetWindowTitle(&fGetWTitlePB);
            titleBuf[titleBuf[0]] = 0x00;
            AlertArray[0] = &titleBuf[2];
            if (AlertWindow(0x0034, AlertArray, 6L) == 1)
                SelectWindow(found);
        }
    }
    return retVal;
}

/*--------------------------------------
    Printer - split out of control handler for fSelector

    Marc Wolfgram, 10/22/91 19:09:16
*/
word Printer(word page)
{
    fPrintPB.resType = CurWindow.resType;
    fPrintPB.resID = CurWindow.resID;
    fPrintPB.fFlag = CurMurphy;
    (GrafPortPtr) fPrintPB.windowPtr = FrontWindow();
    if (page)
	    fPrintPB.fFlag |= 0x2000;
  	if (wClass == REM_nselector) {
     	fPrintPB.fFlag |= 0x0400;   /* set selector bit */
        fPrintPB.fFlag &= 0xff7f;   /* clear menu bit */
	}
    else
    	fPrintPB.fFlag &= 0xfb7f;   /* clear selector and menu bits */

    return callREM(_PRINT, (Pointer) &fPrintPB);

}


word bitFlags[] = {
        0x4000, 0x0800, 0x0080, 0x0040, 0x0010, 0x0008, 0x0004, 0x8000,
        0xbfff, 0xf7ff, 0xff7f, 0xffbf, 0xffef, 0xfff7, 0xfffb, 0x7fff };

/*--------------------------------------
    editAttributes - saved the best, rewrote the rest

    Marc Wolfgram, 10/23/91 21:10:17

        AlertArray[1]   tempName[0]     resID
        AlertArray[2]   tempName[64]    newID
                        tempName[128]   resName
                        tempName[192]   resType/name/file
*/
word editAttributes(word resType, long resID)
{
word i, task, retVal, attr, dirtyID, invalID, done, nlen, bit, chngErr;
GrafPortPtr winP, found, oldP;
nameSubPtr chngSubP;

    miscTaskRec.wmTaskMask = 0x1B2006L;

    done = dirtyID = invalID = 0;
    AlertArray[1] = &tempName[0];
    AlertArray[2] = &tempName[64];

/* set PB constants */

    attrPB.pCount = 4;
    chngPB.pCount = namePB.pCount = 3;
    attrPB.resType = chngPB.resType = namePB.resType = resType;
    attrPB.resID = chngPB.resID = namePB.resID = resID;

    remGetResourceAttr(&attrPB);
    retVal = toolerror();
    if (retVal)
        return retVal;

    namePB.resName = &tempName[64];
    remGetStdTypeName(&namePB);
    if (tempName[64])
        nlen = sprintf(&tempName[192], "*%0.4X %p (%c)", resType, &tempName[64], (char) workIndex + '1');
    else
        nlen = sprintf(&tempName[192], "*%0.4X (%c)", resType, (char) workIndex + '1');
    tempName[192] = (char) nlen - 1;

    namePB.resName = &tempName[128];
    remGetResourceName(&namePB);
    if (!tempName[128])
        sprintf(&tempName[128], (char *) strings[29]);

    sprintf(&tempName[0], "\x08%0.8lX", resID);

/* check to see if ID's can be changed */

   (long) found = (long) findSignature(REM_signature + REM_native + workIndex, 0, resType, resID)
                + (long) findSignature(REM_signature + REM_script + workIndex, 0, resType, resID)
                + (long) findSignature(REM_signature + REM_hexascii + workIndex, 0, resType, resID);
   if (found)
       invalID++;

/* open the attributes window */

    oldP = GetPort();
    winP = NewWindow2(0L, 0L, &AttrProc, 0L, 2, 0xffbL, 0x800e);
    SetPort(winP);

    SetLETextByID(winP, 3L, &tempName[0]);
    if (invalID) {
       i = AlertWindow(0x0035, AlertArray, 11L);
       HiliteControl(0x00ff, GetCtlHandleFromID(winP, 3L));
    }

    ShowWindow(winP);

    SetCtlValue((attrPB.special & 0x0300) + 1,GetCtlHandleFromID(winP, 4L));

    for (i = 0; i < 8; i++)
        if (attrPB.special & bitFlags[i])
            SetCtlValue(1,GetCtlHandleFromID(winP, (long) i + 5));

    do {
        retVal = 0;
        task = TaskMaster(0xffff, &miscTaskRec);
        if (task == wInControl) {
            switch (miscTaskRec.wmTaskData4) {
            case 1L:                                        /* ok button */
                attr = attrPB.special;

                bit = GetCtlValue(GetCtlHandleFromID(winP, 4L)) - 1;
                attr &= 0xfcff;
                attr |= bit;

                for (i = 0; i < 8; i++) {
                    bit = GetCtlValue(GetCtlHandleFromID(winP, (long) i+5));
                    if (bit)
                        attr |= bitFlags[i];
                    else
                        attr &= bitFlags[i+8];
                }

                if (dirtyID) {
                    GetLETextByID(winP, 3L, &tempName[64]);
                    chngPB.result = Hex2Long(&tempName[65], (word) tempName[64]);
                    chngErr = toolerror();

                    if (resID != chngPB.result) {

                        if (!chngPB.result || chngPB.result & 0xf8000000L || chngErr) {
                            i = AlertWindow(0x0035, AlertArray, 10L);
                            SetLETextByID(winP, 3L, &tempName[0]);
                            dirtyID = 0;
                            break;
                        }

                        if (chngPB.result >= 0x07ff0000L) {
                            i = AlertWindow(0x0035, AlertArray, 22L);
                            if (i) {
                            	SetLETextByID(winP, 3L, &tempName[0]);
                            	dirtyID = 0;
                            }
                            break;
                        }

                        chngSubP = getNameSubRec(workIndex, resType, chngPB.result);
                        if (chngSubP) {
                            i = AlertWindow(0x0035, AlertArray, 12L);
                            SetLETextByID(winP, 3L, &tempName[0]);
                            dirtyID = 0;
                            break;
                        }

                        if (AlertWindow(0x0035, AlertArray, 13L)) {
                            remSetResourceID(&chngPB);
                            attrPB.resID = chngPB.result;
                        }
                        else {
                            SetLETextByID(winP, 3L, &tempName[0]);
                            dirtyID = 0;
                            break;
                        }
                    }
                }
                if (attrPB.special != attr) {
                    attrPB.special = attr;
                    remSetResourceAttr(&attrPB);
                }
                done++;
                break;

            case 2L:                                        /* cancel button */
                done++;
                break;

            case 3L:                                        /* id line edit */
                dirtyID++;
                break;

            default:
                break;
            }
        }
    } while(!done);

    SetPort(oldP);
    CloseWindow(winP);
    return retVal;
}

long dAlert[] = {0xfL, 0xeL, 0x12L, 0x13L, 0x14L};

char *dMsg[] = {"orphan resources it uses",
	"cause errors if it is used within another resource",
	"cause errors if it is used within another resource and may orphan resources it uses" };

char dText[128];

/*--------------------------------------
	deleteRequested

	Marc Wolfgram and Mark Collins,  1/ 3/92  0:40:59
*/
word deleteRequested(word resType, long resID)
{
word 			done, retVal, i, dType, hostType, dependents, task;
long			hostID;
Pointer			oldPP;
resLinkRecHndl 	linkH;
GrafPortPtr		winP, oldP;
resLinkRecPtr	linkP;
Rect            dRect;

	oldPP = GetCtlParamPtr();

    miscTaskRec.wmTaskMask = 0x1B2006L;

	done = dependents = hostType = 0;
	hostID = 0L;

    fDeletePB.pCount = 2;
	namePB.pCount = 3;
	namePB.resType = resType;
	namePB.resID = resID;
    namePB.resName = tempName;
    remGetWindowTitle(&namePB);
	sprintf(dText, "%p", tempName);
    AlertArray[0] = dText;		/* use as a cStr */
	dType = 4;					/* default for non-standard type */
	for (i = 0; MasterRace[i].rType; i++) {
		if (MasterRace[i].rType == resType) {
			dType = MasterRace[i].dType;
    		AlertArray[1] = dMsg[dType-1]; /* use as a cStr */
			break;
		}
    }
    retVal = AlertWindow(0x0034, AlertArray, dAlert[dType]);
	if (retVal == 1) {		/* blow the sucker away */
		fDeletePB.resType = resType;
		fDeletePB.resID = resID;
        retVal = remRemoveResource(&fDeletePB);
	}
	else if (retVal) {        /* I want the sucker and his whole family blown away */
        SetCtlParamPtr(&AlertArray);
		oldP = GetPort();
        winP = NewWindow2(0L, 0L, &DrawProc, 0L, 2, 0xefaL, 0x800e);
    	SetPort(winP);
		ShowWindow(winP);
		DrawControls(winP);
        HiliteControl(0x00ff, GetCtlHandleFromID(winP, 0x702dL));
        HiliteControl(0x00ff, GetCtlHandleFromID(winP, 0x702eL));
        HiliteControl(0x00ff, GetCtlHandleFromID(winP, 0x702fL));
        HiliteControl(0x00ff, GetCtlHandleFromID(winP, 0x7030L));

        MoveTo(15,48);
        if (dType & 2) { /* item has parents ( dType is 2 or 3) */
            WaitCursor();

            MoveTo(15,48);
			DrawCString("Checking for parents... ");
			MoveTo(15,48);

            linkH = remFindOwner(resType, resID);
            while ((linkH) && (**linkH).count == 1){
                hostType = (**linkH).ref[0].hostType;
                hostID = (**linkH).ref[0].hostID;
				DisposeHandle((handle) linkH);
        		linkH = remFindOwner(hostType, hostID);
			}
			if (linkH)
				DisposeHandle((handle) linkH);

            if (hostType) {
        		HiliteControl(0x00, GetCtlHandleFromID(winP, 0x702eL));
				namePB.pCount = 3;
				namePB.resType = hostType;
				namePB.resID = hostID;
            	namePB.resName = tempName;
            	remGetWindowTitle(&namePB);
               	sprintf(&tempName[128], (char *) strings[25], tempName);
				DrawCString(&tempName[128]);
			}
			else
				DrawCString("No parent found!              ");

            InitCursor();
        }
        else
			DrawCString("Item has no parent.");

		if (dType & 1) { 	/* may have children */
			MoveTo(15,58);
			DrawCString("Checking for dependents... ");
			MoveTo(15,58);
            fBuildLinkPB.pCount = 4;
            fBuildLinkPB.index = 0;
            fBuildLinkPB.hostType = resType;
            fBuildLinkPB.hostID = resID;
			retVal = remBuildLinkHand(&fBuildLinkPB);   /* callback parameter blocks */
        	dependents = fBuildLinkPB.index;
			DrawCString(dependents ? "Item has dependents.               " : "No item dependents found!          ");
        	if (dependents)
	        	HiliteControl(0x00, GetCtlHandleFromID(winP, 0x702fL));
        }
        else {
            MoveTo(15,58);
			DrawCString("Item has no dependents.");
    	}
        HiliteControl(0x0000, GetCtlHandleFromID(winP, 0x702dL));
	    HiliteControl(0x0000, GetCtlHandleFromID(winP, 0x7030L));
    	do {
        	retVal = 0;
        	task = TaskMaster(0xffff, &miscTaskRec);
        	if (task == wInControl) {
            	switch (miscTaskRec.wmTaskData4) {
				case 0x702dL:  		/* delete single item */
					fDeletePB.resType = resType;
					fDeletePB.resID = resID;
        			retVal = remRemoveResource(&fDeletePB);
                    done++;
                    break;

            	case 0x702eL:      /* delete from parent */
                    MoonCursor();
					if (dependents)
						DisposeHandle(fBuildLinkPB.linkHand);
            		fBuildLinkPB.pCount = 4;
            		fBuildLinkPB.index = 0;
            		fBuildLinkPB.hostType = hostType;
            		fBuildLinkPB.hostID = hostID;
					retVal = remBuildLinkHand(&fBuildLinkPB);   /* callback parameter blocks */

                case 0x702fL:      /*  delete from item */
					(Pointer)linkP = deref(fBuildLinkPB.linkHand);
					dependents = linkP->count;
					for (i = 0; i < dependents; i++) {
                    	MoonCursor();
                        fDeletePB.resType = linkP->ref[i].resType;
						fDeletePB.resID = linkP->ref[i].resID;
        				retVal = remRemoveResource(&fDeletePB);
                    }
					fDeletePB.resType = linkP->ref[0].hostType;
					fDeletePB.resID = linkP->ref[0].hostID;
        			retVal = remRemoveResource(&fDeletePB);

                    DisposeHandle(fBuildLinkPB.linkHand);

            	case 0x7030L:   	/* cancel */
                	done++;
	        		InitCursor();
                	break;

            	default:
                	break;
            	}
        	}
    	} while(!done);

    	SetPort(oldP);
    	CloseWindow(winP);
        SetCtlParamPtr(oldPP);
    }
    return retVal;
}

word exportRequested (word resType, long resID)
{
word retVal;

    retVal = AlertWindow(0x0034, 0L, Construction_Alert);
    retVal = -1;
    return retVal;
}

word findHostRequested(word resType, long resID)
{
word retVal;

    retVal = AlertWindow(0x0034, 0L, Construction_Alert);
    retVal = -1;
    return retVal;
}

word findChildRequested(word resType, long resID)
{
word retVal;

    retVal = AlertWindow(0x0034, 0L, Construction_Alert);
    retVal = -1;
    return retVal;
}

/* DEBUG WINDOW */
segment "F_INTERNAL";

char		bTextPtr[255];

void UpdateBWin(word task)
{
GrafPortPtr oldPort;

	if (!bWinPtr)
		return;

	oldPort = GetPort();
	SetPort(bWinPtr);

	sprintf(bTextPtr, "Task/Modifiers... %0.4x/%0.4x   ", task, fTaskRec.modifiers);
	MoveTo(10,10);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "FileLink root... %0.8lx   ", (long) linkREM);
	MoveTo(10,20);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "TypeLink root... %0.8lx   ", (long) rootREM);
	MoveTo(10,30);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Menu Global... %0.4x   ", fMenuGlobal);
	MoveTo(10,40);
	DrawCString(bTextPtr);

	MoveTo(10,55);
	DrawCString("Active Window Information");

	sprintf(bTextPtr, "Signature... %0.4x  ", CurWindow.Signature);
	MoveTo(20,65);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Resource Type... %0.4x  ", CurWindow.resType);
	MoveTo(20,75);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Resource ID... %0.8lx    ", CurWindow.resID);
	MoveTo(20,85);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Resource File... %0.4x  ", CurWindow.resFileID);
	MoveTo(20,95);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Requested TaskMask... %0.8lx  ", CurWindow.remTaskMask);
	MoveTo(20,105);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "remSignature... %0.4x  ", CurWindow.remSignature);
	MoveTo(20,115);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "resPrivate... %0.8lx   ", CurWindow.resPrivate);
	MoveTo(20,125);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Applied TaskMask... %0.8lx   ", fTaskRec.wmTaskMask);
	MoveTo(10,140);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Internal Group... %0.4x  ", wClass);
	MoveTo(10,150);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Internal Murphy... %0.4x  ", CurMurphy);
	MoveTo(10,160);
	DrawCString(bTextPtr);

	sprintf(bTextPtr, "Editor Entry Vector... %0.8lx  ", callVector);
	MoveTo(10,170);
	DrawCString(bTextPtr);

	SetPort(oldPort);
}

void bWindow(void)
{
word temp;
fWindowRecHndl  refH;
fWindowRecPtr   refP;

	if (!bWinPtr) {
    	if (fTaskRec.modifiers & 0x0800) {
        	refH = (fWindowRecHndl) NewHandle(20L, fMemID, 0x0018, 0L);
    		(Pointer) refP = deref((Handle) refH);
    		refP->Signature     = REM_signature + 0xef;
    		refP->resType       = 0;
    		refP->resID         = 0L;
        	refP->resFileID     = 0;
    		refP->remTaskMask   = 0x001f7fffL;
    		refP->remSignature  = 0;
    		refP->resPrivate    = 0L;
	    	HUnlock(refH);
			bWinPtr = NewWindow2(0L, refH, &NullProc, 0L, 2, 0xef9L, rWindParam1);
		}
		else
        	temp = AlertWindow(0x0034, 0L, Construction_Alert);
	}
	else {
		DisposeHandle(GetWRefCon(bWinPtr));
		CloseWindow(bWinPtr);
		bWinPtr = 0L;
	}
}
